/******************************************************************************
 * Technical University of Darmstadt
 * Industrial Process and System Communication
 * Project: TCP
 * Filename: HistPanel.java
 * Author: Gunter Weiss
 * Contents: Draws Lines and places these in a panel
 * Last Changes: Gunter Weiss 23/4/97
 *****************************************************************************/

import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Graphics;
import java.awt.Event;
import java.awt.Color;

/******************************************************************************
* Class: HistPanel
* Description: Loads images and places these images in a panel
******************************************************************************/
public class HistPanel extends Panel {
  String file;
  int size,dx, dy;
  TcpStarter starter;

  public HistPanel ( TcpStarter target, String ident ){
    starter=target;
    setSize( ident );
    changeSize( 1 ,ident );
    setLayout( null );
    validate();
    show();
  }

/******************************************************************************
* Method: paint
* Description: draws the line.
* Parameters: the used graphic
* Return Value: none
******************************************************************************/
  public void paint( Graphics g ){
    g. setColor(Color.blue);
    g. fillRect( 0, 0, dx, dy );
    //g. drawImage( image, 0, 0, dx, dy, this );
  }

/******************************************************************************
* Method: update
* Description:
* Parameters: the used graphic
* Return Value: none
******************************************************************************/
  public void update( Graphics g ){
    paint( g );
  }

/******************************************************************************
* Method: setSize
* Description: Defines the Dimension of Lines.
* Parameters: identifier for the kind of line.
* Return Value: none
******************************************************************************/
  public void setSize( String ident ){
    if ( ident.equals("layer4_5-1") ) {
      dx = 90; dy = 2;
    }
    else
      if ( ident.equals("layer3_4-1") ) {
       dx = 90; dy = 2;
    }
  }

/******************************************************************************
* Method: changeSize
* Description: scales the images and paints them
* Parameters: quality factor
* Return Value: none
******************************************************************************/
  public void changeSize( int qual , String ident){
    size = qual;
    ident = ident;
    if( size == 1 ){
      dx = 90;   //factor 1
      dy = 2;
    }
    else if( size == 2 ){
      dx = 113;  //factor 1,25
      dy = 3;
    }
    else if( size == 3 ){
      dx = 144;  //factor 1,6
      dy = 3;
    }
    else if( size == 4 ){
      dx = 180;  //factor 2
      dy = 4;
    }
    if ( ident.equals( "netpict") ) {
        dx = dx * 2;
    }
    resize( dx, dy );
    repaint();
    validate();
  }
}












